﻿/*
VERSION:		1.3

1.3		Allow "defaultContainer" to be either an object reference or a string

USAGE:
	#include "functions/getPathValue.as"
	var value = getPathValue( path );

DESCRIPTION:
	Returns the value of a variable path.
*/
getPathValue = function( path, defaultContainer )
{
	// resolve optional parameters
	var path = (path) ? path : "";
	var defaultContainer = (defaultContainer) ? defaultContainer : "RAM";
	
	// remove spaces  (if it's a string)
	if( typeof(path) == "string" )
		path = path.split(" ").join("");
	
	var startAt = path.indexOf(".");
	if(startAt == undefined)
	{// if:  path is NOT a string
		var output = path;		// just spit it back out
	}// if:  path is NOT a string
	else if(startAt==-1)
	{// if:  path has NO sub-objects
		var containerIsGlobal = eval("_global."+path);
		
		if(path=="this")
			containerIsGlobal = true;
			
		if( typeof( defaultContainer ) == "string" ){
			var output = (containerIsGlobal) ? eval(path) : eval(defaultContainer+"."+path);
		}else{
			// defaultContrainer is (probably) an object reference
			var output = (containerIsGlobal) ? eval(path) : defaultContainer[path];
		}
	}// if:  path has NO sub-objects
	else
	{// if:  path has sub-objects
		var containerEnd = path.indexOf(".");
		var containerName = path.substr(0, containerEnd);
		
		var containerIsGlobal = eval("_global."+containerName);
		
		if(containerName == "this")
			containerIsGlobal = true;
		if(containerName == "_level0")
			containerIsGlobal = true;
		
		if(!containerIsGlobal)					// if:  missing a global container
			path = "RAM."+path;			// assume it's inside of RAM container
		// else:  the path already starts with a global object and can be used with eval() directly
		var output = eval(path);
	}// if:  path has sub-objects
	
	
	return output;
}// getPathValue()